/*
 * Created on Dec 4, 2009
 * 
 * Description: This class is used to test the image utility functions 
 * with PNG and TIF files.
 */

package org.xenbase.scraper.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import junit.framework.TestCase;

import org.xenbase.utilities.AdvImageUtil;

/**
 * @author Chris Jarabek (cjjarabe@ucalgary.ca)
 *
 */
public class ImageUtilsTest extends TestCase{
	ImageUtilsTest(String name){
		super(name);
		System.out.println("Creating new class instance of org.xenbase.scraper.runner.ImageUtilsTest");
	}
	
	/**Test case that runs through the image utilities functions with a test PNG and TIF
	 * file (see hardcoded path in code body).  No tests were performed on JPG, because
	 * exhaustive manual testing has been performed on JPG encoded images.	 * 
	 */
	public void test_TIF_PNG() {
		try {
			//Read the files into byte arrays
			File png = new File("./testData/test.png");
			File tif = new File("./testData/test.tif");
			byte[] pngB = getBytesFromFile(png);
			byte[] tifB = getBytesFromFile(tif);
			
			//Get the height / width of the files
			assertTrue(AdvImageUtil.getFileType(pngB) == "png");
			assertTrue(AdvImageUtil.getFileType(tifB) == "tif");
			assertTrue(AdvImageUtil.getHeight(pngB) > 0);
			assertTrue(AdvImageUtil.getHeight(tifB) > 0);
			assertTrue(AdvImageUtil.getWidth(pngB) > 0);
			assertTrue(AdvImageUtil.getWidth(tifB) > 0);
			
			//Try scaling the files
			
			pngB = AdvImageUtil.scaleTo(200, 200, pngB);
			tifB = AdvImageUtil.scaleTo(300, 300, tifB);			
			assertTrue(AdvImageUtil.getHeight(pngB) == 200);
			assertTrue(AdvImageUtil.getWidth(pngB) == 200);
			assertTrue(AdvImageUtil.getHeight(tifB) == 300);
			assertTrue(AdvImageUtil.getWidth(tifB) == 300);			
			
			pngB = AdvImageUtil.scaleToFit(640, 480, pngB);			
			tifB = AdvImageUtil.scaleToFit(800, 600, tifB);			
			assertTrue(AdvImageUtil.getHeight(pngB) == 480);
			assertTrue(AdvImageUtil.getWidth(pngB) == 480);
			assertTrue(AdvImageUtil.getHeight(tifB) == 600);
			assertTrue(AdvImageUtil.getWidth(tifB) == 600);			

			//Try converting the files to JPG
			pngB = AdvImageUtil.convertTo("jpg", pngB);
			tifB = AdvImageUtil.convertTo("jpg", tifB);
			
			assertTrue(AdvImageUtil.getFileType(pngB) == "jpg");
			assertTrue(AdvImageUtil.getFileType(tifB) == "jpg");
		
			//Save the image
            File fi = new File(("./scraperOutput/png.jpg"));
            FileOutputStream fos = new FileOutputStream(fi);
            fos.write(pngB);

            //Save the image
            File fi2 = new File(("./scraperOutput/tif.jpg"));
            FileOutputStream fos2 = new FileOutputStream(fi2);
            fos2.write(tifB);

			
		} catch (Exception e) {
			System.out.println(e.getMessage());
		} catch (Error e) {
			System.out.println(e.getMessage());
		}
	}
	
	public static byte[] getBytesFromFile(File file) throws IOException {
        InputStream is = new FileInputStream(file);   
        long length = file.length();   
        if (length > Integer.MAX_VALUE) {
            throw new IOException();
        }   
        byte[] bytes = new byte[(int)length];   
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length
               && (numRead=is.read(bytes, offset, bytes.length-offset)) >= 0) {
            offset += numRead;
        }   
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file "+file.getName());
        }   
        is.close();
        return bytes;
    }
}
